﻿var roles = {
    context: $(".v-quotas-roles"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-roles-table", this.context).a4datatable({            
            height: "full",
            ajaxAction: a4.getProjectAction("GetRoles", "Quotas"),
            ajaxParams: {},
            columns: [
                { "Title": resources.Id, "Data": "Id", "Key": true, "Type": "numeric", "HideInSelector": true, "Visible": false },
                { "Title": resources.Name, "Name": "Name", "Data": "Name", "Type": "string", "Editable": true }
            ],
            localizableTexts: { "Search": resources.SearchRoles },
            stateKey: "QuotasRoles",
            allowRowSelection: "![IsUse]",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return !data.IsUse; } },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        roles.deleteRoles([row.Id]);
                        break;
                    case "properties":
                        roles.editRoles(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    roles.deleteRoles(ids);
                }
            },
            displayColumnSelector: false,
            
        });
    },
    bindEvents: function () {
        roles.context.on("click", ".h-add-roles", function () {
            modalDialog.showWindow(a4.getProjectAction("EditRole", "Quotas"), 280, 600, { afterClose: function () { roles.refreshContent(); } });
        });

        roles.context.on("click", ".h-exportRoles", function () {
            var columns = roles.datatable.a4datatable("getVisibleColumns");
            var tableParams = roles.datatable.a4datatable("getTableParams");

            var params = {
                table: JSON.stringify(tableParams),
                columns: columns.join()
            };

            a4.showBusyBox();
            a4.callServerMethod(a4.getProjectAction("ExportRoles", "Quotas"), params,
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getProjectAction("GetRolesFile", "Quotas", { fileName: result });
                });
        });

        roles.context.on("click", ".h-copyRoles", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyRoles", "Quotas"), { sourceProjectId: sourceProjectId },
                function (result) {
                    roles.refreshContent();
                });
            }, resources.CopyRoles, false, confirmCopyRoleResources, true);
        });
    },
    deleteRoles: function (roleIds) {
        modalDialog.showConfirmDelete(confirmDeleteRolesResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteRoles", "Quotas"), { roleIds: roleIds },
                function (result) {
                    if (!result.success)
                        a4.showErrorMessage(result.error);
                    roles.refreshContent();
                });
        }, roleIds.length);
    },
    editRoles: function (roleId) {
        modalDialog.showWindow(a4.getProjectAction("EditRole", "Quotas", { roleId: roleId }), 280, 600, { afterClose: function () { roles.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    }
}

$(document).ready(function () {
    if (roles.context.length > 0) {
        roles.initializeDataTable();
        roles.bindEvents();
    }
});